// XISLDialogTag.cpp: CXISLDialogTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLDialogTag.h"
#include "XISLExchangeTag.h"
#include "XISLCombExchangeTag.h"
#include "XISLOutputTag.h"
#include "XISLCallTag.h"
#include "XISLOutputBrowser.h"
#include "XISLVarList.h"
#include "XISLVar.h"
#include "XISLRootTag.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLDialogTag::CXISLDialogTag()
{
	m_nTagType = ID_TAG_DIALOG;
	m_nComb = 0;
	m_nScope = 0;
	m_nRepeat = 1;
	m_strID = "";

	m_nBmpID = IDB_DIALOG;

	m_pBegin = NULL;
	m_pEnd = NULL;
	m_pDialogVar = new CXISLVarList(this);
	m_bDummy = FALSE;
	m_strWindowID="";
	m_strURI="";
}


CXISLDialogTag::CXISLDialogTag(const CXISLDialogTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_strWindowID = cpXISL.m_strWindowID;
	m_strURI = cpXISL.m_strURI;
	m_nComb = cpXISL.m_nComb;
	m_nRepeat = cpXISL.m_nRepeat;
	m_nScope = cpXISL.m_nScope;
	m_strID = cpXISL.m_strID;
	m_pBegin = cpXISL.m_pBegin;
	m_pEnd = cpXISL.m_pEnd;
	m_pDialogVar = cpXISL.m_pDialogVar;
	m_bDummy = cpXISL.m_bDummy;

	POSITION pos = m_ExchangeList.GetHeadPosition();
	while(pos)
	{
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetNext(pos);
		delete pExcItem;
	}
	m_ExchangeList.RemoveAll();
	pos = m_ExchangeList.GetHeadPosition();
	while(pos)
		m_ExchangeList.AddTail(cpXISL.m_ExchangeList.GetNext(pos));

	pos = m_ReCallList.GetHeadPosition();
	while(pos)
	{
		CXISLCallTag *pCallTag = (CXISLCallTag*)m_ReCallList.GetNext(pos);
		delete pCallTag;
	}
	m_ReCallList.RemoveAll();
	pos = m_ExchangeList.GetHeadPosition();
	while(pos)
		m_ReCallList.AddTail(cpXISL.m_ReCallList.GetNext(pos));

	pos = m_ArgList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_ArgList.GetNext(pos);
		delete pVar;
	}
	m_ArgList.RemoveAll();
	pos = m_ArgList.GetHeadPosition();
	while(pos)
		m_ArgList.AddTail(cpXISL.m_ArgList.GetNext(pos));
}

CXISLDialogTag::~CXISLDialogTag()
{
	POSITION pos = m_ExchangeList.GetHeadPosition();
	while(pos)
	{
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetNext(pos);
		delete pExcItem;
	}
	if(m_pBegin)
	{
		delete m_pBegin;
		m_pBegin = NULL;
	}
	if(m_pEnd)
	{
		delete m_pEnd;
		m_pEnd = NULL;
	}
	if(m_pDialogVar)
	{
		delete m_pDialogVar;
		m_pDialogVar = NULL;
	}
}

CXISLDialogTag& CXISLDialogTag::operator=(const CXISLDialogTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		POSITION pos = m_ExchangeList.GetHeadPosition();
		while(pos)
		{
			CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetNext(pos);
			delete pExcItem;
		}
		m_ExchangeList.RemoveAll();
		pos = m_ExchangeList.GetHeadPosition();
		while(pos)
			m_ExchangeList.AddTail(cpXISL.m_ExchangeList.GetNext(pos));

		pos = m_ReCallList.GetHeadPosition();
		while(pos)
		{
			CXISLCallTag *pCallTag = (CXISLCallTag*)m_ReCallList.GetNext(pos);
			delete pCallTag;
		}
		m_ReCallList.RemoveAll();
		pos = m_ExchangeList.GetHeadPosition();
		while(pos)
			m_ReCallList.AddTail(cpXISL.m_ReCallList.GetNext(pos));

		pos = m_ArgList.GetHeadPosition();
		while(pos)
		{
			CXISLVar *pVar = (CXISLVar*)m_ArgList.GetNext(pos);
			delete pVar;
		}
		m_ArgList.RemoveAll();
		pos = m_ArgList.GetHeadPosition();
		while(pos)
			m_ArgList.AddTail(cpXISL.m_ArgList.GetNext(pos));
		
		m_nComb = cpXISL.m_nComb;
		m_nRepeat = cpXISL.m_nRepeat;
		m_nScope = cpXISL.m_nScope;
		m_strID = cpXISL.m_strID;
		m_pBegin = cpXISL.m_pBegin;
		m_pEnd = cpXISL.m_pEnd;
		m_pDialogVar = cpXISL.m_pDialogVar;
		m_bDummy = cpXISL.m_bDummy;
		m_strWindowID = cpXISL.m_strWindowID;
		m_strURI = cpXISL.m_strURI;
	}
	return *this;
}


//OC^tF[X
BOOL CXISLDialogTag::IsModalWindowUsed(CString &strURI,CString &strWID)
{
	strURI = m_strURI;
	strWID = m_strWindowID;
	if(m_strWindowID.Compare("Main") == 0)
		return FALSE;
	else
		return TRUE;
}

void CXISLDialogTag::SetDocName(LPCTSTR lpszDocName)
{
	if(m_bDummy)
	{
		m_strDummyDocName = lpszDocName;
		return;
	}
	CXISLRootTag *pRTag = (CXISLRootTag*)GetRootTag();
	pRTag->SetDocName(lpszDocName);
}

LPCTSTR CXISLDialogTag::GetDocName()
{
	if(m_bDummy)
		return m_strDummyDocName;

	CXISLRootTag *pRTag = (CXISLRootTag*)GetRootTag();
	return pRTag->GetDocName();
}

//ƂĎgpĂϐ폜
//F0@ʂ̏ꏊŎgpĂϐF-1
int CXISLDialogTag::ResetArgVar()
{
	int nRet = 0;
	POSITION pos = m_ArgList.GetHeadPosition();
	while(pos)
	{
		POSITION oldPos = pos;
		CXISLVar *pDelVar = (CXISLVar*)m_ArgList.GetNext(pos);
		if(m_pDialogVar->RemoveVar(pDelVar) == 0)
		{
			m_ArgList.RemoveAt(oldPos);
			delete pDelVar;
		}
		else
			nRet = -1;
	}

	return nRet;
}

//dialogargɕϐo^
//łdialogϐƂĂo^
//@CXISLVar*
//:0 s:-1
int CXISLDialogTag::RegistDialogArg(CXISLVar *pVar)
{
	if(m_pDialogVar->RegistVar(pVar) != 0)
	{
		AfxMessageBox("̕ϐ͊ɓo^ς݂łD",
						MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return -1;		
	}
	m_ArgList.AddTail(pVar);
	return 0;
}

//dialogarg̕ϐ폜
//łdialogϐ폜
//@CXISLVar*
//F0 @̕ϐQƂĂ܂݂F-1
//̕ϐ̓Xgɑ݂ȂF-2
int CXISLDialogTag::RemoveDialogArg(CXISLVar *pVar)
{
	int nRet = m_pDialogVar->RemoveVar(pVar);
	if(nRet == 0)
	{
		POSITION pos = m_ArgList.Find(pVar);
		if(pos == NULL)
			ASSERT(NULL);
		m_ArgList.RemoveAt(pos);
		return 0;
	}
	return nRet;
}

//int CXISLDialogTag::SetDialogAttribute(LPCTSTR lpszID,int nComb,int nRepeat,int nScope)
//dialog̑lݒ
//F0@IDsF-1
int CXISLDialogTag::SetDialogAttribute(LPCTSTR lpszID,int nComb,int nRepeat,int nScope)
{
	CXISLRootTag *pRootTag = (CXISLRootTag*)GetRootTag();
	if(!m_bDummy)
	{
		if(m_strID != lpszID)
		{
			if(pRootTag->FindDTag(lpszID))
			{
				AfxMessageBox("Dialog ID͊ɓo^Ă܂B\r\nʂIDgpĂ",
							MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				return -1;
			}
		}
	}
	m_strID = lpszID;
	m_nComb = nComb;
	m_nRepeat = nRepeat;
	m_nScope = nScope;
	m_bValid = TRUE;
	return 0;
}

//int CXISLDialogTag::SetDialogAttribute(LPCTSTR lpszID,LPCTSTR lpszComb,LPCTSTR lpszRepeat,LPCTSTR lpszScope,LPCTSTR lpszArg)
//dialog̑lݒ(XISLt@C[hꍇgp)
//F0@IDsF-1 sF-2
int CXISLDialogTag::SetDialogAttribute(LPCTSTR lpszID,LPCTSTR lpszComb,LPCTSTR lpszRepeat,LPCTSTR lpszScope,LPCTSTR lpszArg)
{
	CXISLRootTag *pRootTag = (CXISLRootTag*)GetRootTag();
	if(m_strID != lpszID)
	{
		if(pRootTag->FindDTag(lpszID))
		{
			AfxMessageBox("Dialog ID͊ɓo^Ă܂B\r\nʂIDgpĂ",
						MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return -1;
		}
	}
	m_strID = lpszID;
	int i=0;
	while(1)
	{
		if(strcmp(XISL_COMB[i],lpszComb) == 0)
			break;
		i++;
	}
	m_nComb = i;
	m_nRepeat = atoi(lpszRepeat);
	if(strcmp(XISL_SCOPE[ID_DIASCOPE_DIALOG],lpszScope) == 0)
		m_nScope = ID_DIASCOPE_DIALOG;
	else
		m_nScope = ID_DIASCOPE_DOCUMENT;

	ResetArgVar();
	CString strTemp = lpszArg;
	if(!strTemp.IsEmpty())
	{
		int nRet;
		int nCount;
		BOOL bFlag=TRUE;
		BOOL bFin = FALSE;
		while(!bFin)
		{
			CString strVarName;
			nCount = strTemp.Find(",");
			if(nCount == -1)
			{
				strVarName = strTemp;
				bFin = TRUE;
			}
			else
				strVarName = strTemp.Left(nCount);

			CXISLVar *pVar = new CXISLVar;
			if(pVar->SetAttribute(strVarName,"",FALSE,FALSE) == 0)
			{
				m_ArgList.AddTail(pVar);
				if(m_pDialogVar->RegistVar(pVar))
				{
					m_ArgList.RemoveTail();
					bFlag = FALSE;
					nRet = -2;
					break;
				}
				pVar->ReferCount(TRUE);
			}
			else
			{
				delete pVar;
				bFlag = FALSE;
				nRet = -2;
				break;
			}
			strTemp.Delete(0,nCount+1);
		}
		if(!bFlag)
		{
			ResetArgVar();
			m_bValid = FALSE;
			return nRet;
		}
	}
	m_bValid = TRUE;
	return 0;
}


int CXISLDialogTag::GetDialogArgCount()
{
	if(m_bDummy)
		return m_nDummyArgCount;
	else
		return m_ArgList.GetCount();
}

//LPCTSTR CXISLDialogTag::GetXISLString()
//@\@FDialogȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLDialogTag::GetXISLString()
{
//	CString strComb = XISL_COMB[m_nComb];
	char cRepeat[15];
	if(m_nRepeat == 0)
		strcpy(cRepeat,"indefinite");
	else
		itoa(m_nRepeat,cRepeat,10);

//	CString strScope = XISL_SCOPE[m_nScope];

	CString strArg;
	POSITION pos = m_ArgList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_ArgList.GetNext(pos);
		strArg += pVar->GetVarName();
		strArg += ",";
	}
	strArg.Delete(strArg.GetLength()-1);
	m_strXISL = "<dialog id=\"" + m_strID;
	m_strXISL += "\" comb=\"";
	m_strXISL += XISL_COMB[m_nComb];
	m_strXISL += "\" repeat=\"";
	m_strXISL += cRepeat;
	m_strXISL += "\" scope=\"";
	m_strXISL += XISL_SCOPE[m_nScope];
	if(!strArg.IsEmpty())
	{
		m_strXISL += "\" arg=\"";
		m_strXISL += strArg;
	}
	m_strXISL += "\">\r\n";

	if(m_pDialogVar)
	{
		CString strTemp;
		m_pDialogVar->GetXISLString(strTemp);
		m_strXISL += strTemp;
	}

	if(m_pBegin)
		m_strXISL += m_pBegin->GetXISLString();

	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *exchangeItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);
		if(exchangeItem->m_nTagType == ID_TAG_EXCHANGE)
			m_strXISL += ((CXISLExchangeTag*)exchangeItem)->GetXISLString();
		else
			m_strXISL += ((CXISLCombExchangeTag*)exchangeItem)->GetXISLString();
	}

	if(m_pEnd)
		m_strXISL += m_pEnd->GetXISLString();

	m_strXISL += "</dialog>\r\n";

	return (LPCTSTR)m_strXISL;
}

//int CXISLDialogTag::GetItemCount()
//@\@FdialogȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLDialogTag::GetItemCount()
{
	int nCount = 0;

	if(m_pBegin)
		nCount += m_pBegin->GetItemCount();

	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

		if(pExcItem->m_nTagType == ID_TAG_EXCHANGE)
			nCount += ((CXISLExchangeTag*)pExcItem)->GetItemCount();
		else
			nCount += ((CXISLCombExchangeTag*)pExcItem)->GetItemCount();
	}

	if(m_pEnd)
		nCount += m_pEnd->GetItemCount();

	nCount++;
	return nCount;
}


//DialogCall邩H
BOOL CXISLDialogTag::IsSubDialog()
{
	POSITION pos = m_ReCallList.GetHeadPosition();
	while(pos)
	{
		CXISLTag *pTag = (CXISLTag*)m_ReCallList.GetNext(pos);
		if(pTag->m_nTagType == ID_TAG_CALL)
			return TRUE;
	}

	return FALSE;
}

//ĂяoƂcall^OXgɒǉ
BOOL CXISLDialogTag::AddReCallTag(CXISLCallTag *pTag)
{
	if(m_ReCallList.Find(pTag))
		ASSERT(NULL);
	else
	{
		m_ReCallList.AddTail(pTag);
		pTag->m_pNextDialog = this;
	}

	return TRUE;
}

//XgĂяoƂcall^O͂
BOOL CXISLDialogTag::RemoveReCallTag(CXISLCallTag *pTag)
{
	POSITION pos = m_ReCallList.Find(pTag);
	if(pos)
	{
		m_ReCallList.RemoveAt(pos);
		pTag->m_pNextDialog = NULL;
		return TRUE;
	}

	return FALSE;
}

//Ăьłcall^OreturňԂ
int CXISLDialogTag::GetReCallReturnCount()
{
	POSITION pos = m_ReCallList.GetHeadPosition();
	while(pos)
	{
		CXISLTag *pTag = (CXISLTag*)m_ReCallList.GetNext(pos);
		if(pTag->m_nTagType == ID_TAG_CALL)
			return ((CXISLCallTag*)pTag)->GetReturnCount();
	}

	return -1;
}

//Ăьłcall^ÕXg󂯎R{{bNXɑ}
//return^O̖߂w肷邽߂CallR{{bNXɑ}
void CXISLDialogTag::SetCmb4ReCallTag(CComboBox &cmbCtrl)
{
	POSITION pos = m_ReCallList.GetHeadPosition();
	int i=0;
	CXISLDialogTag *pOldTag=NULL;
	int nCount=0;
	while(pos)
	{
		CXISLTag *pTag = (CXISLTag*)m_ReCallList.GetNext(pos);
		if(pTag->m_nTagType == ID_TAG_CALL)
		{
			CXISLDialogTag *pDTag = (CXISLDialogTag*)pTag->GetParentDialogTag();
			CString strTemp = pDTag->GetDialogID();
			strTemp += "#call";
			cmbCtrl.AddString(strTemp);
			cmbCtrl.SetItemDataPtr(i,pTag);
			i++;
		}
	}
}

//Xgr[Ɉ\
//pVarɂ͐̃eLXgĂȂ
void CXISLDialogTag::SetArgVarList2LBox(CListCtrl &lbCtrl)
{
	lbCtrl.DeleteAllItems();
	LVITEMA item;

	CString strTemp;
	int nCount=0;
	POSITION pos = m_ArgList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_ArgList.GetNext(pos);

		item.mask = LVIF_TEXT|LVIF_PARAM;
		item.iItem = nCount;
		item.iSubItem = 0;
		item.lParam = (LPARAM)pVar;
		strTemp = pVar->GetVarName();
		item.pszText = strTemp.GetBuffer(2);
		lbCtrl.InsertItem(&item);

		item.mask = LVIF_TEXT;
		item.iSubItem = 1;
		item.pszText = "";
		lbCtrl.SetItem(&item);

		nCount++;
	}
}

//CXISLExchangeTag* CXISLDialogTag::InsertExchange(int nComb,LPCTSTR lpszURI="",CXISLTag *pPlaceTag=NULL);
//@\@Fw肵^ȌꏊɁCexchange}
//	Fint nComb			:comb
//@@@FLPCTSTR lpszURI	FURI
//		FCXISLTag *pPlaceTag		FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFIuWFNg̃|C^
CXISLExchangeTag* CXISLDialogTag::InsertExchange(int nComb,LPCTSTR lpszURI,CXISLTag *pPlaceTag)
{
	CXISLExchangeTag *pExchangeTag;

	pExchangeTag = new CXISLExchangeTag((CXISLTag*)this,nComb,lpszURI);

	//pPlaceTagw肵ĂȂC̏ꏊ̌ɑ}
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pExchangeTag);
				break;
			}
		}
		return NULL;
	}
	else
	{
		m_ExchangeList.AddTail((CXISLExcItem*)pExchangeTag);
	}

	return pExchangeTag;
}

//CXISLExchangeTag* CXISLDialogTag::InsertExchange(CXISLExchangeTag *pExcTag,CXISLTag *pPlaceTag)
//@\@Fw肵^ȌꏊɁCexchange𐶐
//	FCXISLExchangeTag *pExcTag	:}^O.NULLȂVK쐬
//		FCXISLTag *pPlaceTag		FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFIuWFNg̃|C^
CXISLExchangeTag* CXISLDialogTag::InsertExchange(CXISLExchangeTag *pExcTag,CXISLTag *pPlaceTag)
{
	if(pExcTag)
		pExcTag->m_pParentTag = this;
	else
		ASSERT(NULL);

	//pPlaceTagw肵ĂȂC̏ꏊ̌ɑ}
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pExcTag);
				break;
			}
		}
		return NULL;
	}
	else
	{
		m_ExchangeList.AddTail((CXISLExcItem*)pExcTag);
	}

	return pExcTag;
}

//CXISLCombExchangeTag* CXISLDialogTag::InsertCombExchange(int nCombType,CXISLTag *pPlaceTag=NULL);
//@\@F***_exchangȇ}
//@\	Fw肵^ȌꏊɁC***_exchange}C̃^OqɎ悤ɂ
//	Fint nCombType						:***_exchangẽ^Cvpar,alt,seq
//		FCXISLTag *pPlaceTag				FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFCXISLCombExchangeTag*@sFNULL
CXISLCombExchangeTag* CXISLDialogTag::InsertCombExchange(int nCombType,CXISLTag *pPlaceTag)
{
	CXISLCombExchangeTag *pCombExchangeTag;

	pCombExchangeTag = new CXISLCombExchangeTag((CXISLTag*)this,nCombType);

	//pPlaceTagw肵ĂȂC̏ꏊɑ}CpPlaceTagqɈړ
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pCombExchangeTag);
				m_ExchangeList.RemoveAt(pos);
				((CXISLCombExchangeTag*)pCombExchangeTag)->InsertExchange((CXISLExchangeTag*)pTag);
				break;
			}
		}
	}
	else
	{
		m_ExchangeList.AddTail((CXISLExcItem*)pCombExchangeTag);
	}

	return pCombExchangeTag;
}

//CXISLCombExchangeTag* CXISLDialogTag::InsertCombExchange(CXISLCombExchangeTag *pCombExcTag,CXISLTag *pPlaceTag)
//@\@F***_exchangȇ}
//@\	Fw肵^ȌꏊɁC***_exchange}C̃^OqɎ悤ɂ
//	FCXISLCombExchangeTag *pCombExcTag	:}^O.
//		FCXISLTag *pPlaceTag				FΏۂƂȂ^O.NULLȂ烊Xg̍Ōɑ}
//ԂlFCXISLCombExchangeTag*@sFNULL
CXISLCombExchangeTag* CXISLDialogTag::InsertCombExchange(CXISLCombExchangeTag *pCombExcTag,CXISLTag *pPlaceTag)
{
	if(pCombExcTag)
		pCombExcTag->m_pParentTag = this;
	else
		ASSERT(NULL);

	//pPlaceTagw肵ĂȂC̏ꏊɑ}CpPlaceTagqɈړ
	if(pPlaceTag)
	{
		int nCount = m_ExchangeList.GetCount();
		for(int i=0; i<nCount; i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLTag *pTag = (CXISLTag*)m_ExchangeList.GetAt(pos);
			if(pTag == pPlaceTag)
			{
				m_ExchangeList.InsertAfter(pos,(void*)pCombExcTag);
				m_ExchangeList.RemoveAt(pos);
				pCombExcTag->InsertExchange((CXISLExchangeTag*)pTag);
				break;
			}
		}
	}
	else
	{
		m_ExchangeList.AddTail((CXISLExcItem*)pCombExcTag);
	}

	return pCombExcTag;
}


//CXISLBeginEndTag* CXISLDialogTag::CreateBegin()
//@\@Fbegin̐
//@F
//ԂlFCXISLBeginEndTag*@sFFALSE
CXISLBeginEndTag* CXISLDialogTag::CreateBegin()
{
	if(m_pBegin)
	{
		AfxMessageBox("<begin>͊ɍ쐬Ă܂");
		return NULL;
	}
	else
		m_pBegin = new CXISLBeginEndTag((CXISLTag*)this,ID_TAG_BEGIN);

	return m_pBegin;
}

//Begin^O̍폜
//2003/5/20@
void CXISLDialogTag::DestroyBegin()
{
	m_pBegin->DeleteAllAct();
	delete m_pBegin;
	m_pBegin=NULL;
}

//CXISLBeginEndTag* CXISLDialogTag::CreateEnd()
//@\@Fend̐
//@F
//ԂlFCXISLBeginEndTag*@sFFALSE
CXISLBeginEndTag* CXISLDialogTag::CreateEnd()
{
	if(m_pEnd)
	{
		AfxMessageBox("<end>͊ɍ쐬Ă܂");
		return NULL;
	}
	else
		m_pEnd = new CXISLBeginEndTag((CXISLTag*)this,ID_TAG_END);

	return m_pEnd;
}

//Begin^O̍폜
//2003/5/20@
void CXISLDialogTag::DestroyEnd()
{
	m_pEnd->DeleteAllAct();
	delete m_pEnd;
	m_pEnd = NULL;
}

//BOOL CXISLDialogTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLDialogTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_DIALOG];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	if(m_pBegin)
		m_pBegin->RegistXISLTree(pTree,hParent);

	for(int i=0; i<m_ExchangeList.GetCount(); i++)
	{
		POSITION pos = m_ExchangeList.FindIndex(i);
		CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

		pExcItem->RegistXISLTree(pTree,hParent);
/*		if(pExcItem->m_nTagType == ID_TAG_EXCHANGE)
			((CXISLExchangeTag*)pExcItem)->RegistXISLTree(pTree,hParent);
		else
			((CXISLCombExchangeTag*)pExcItem)->RegistXISLTree(pTree,hParent);
*/
	}

	if(m_pEnd)
		m_pEnd->RegistXISLTree(pTree,hParent);

	return TRUE;
}

//CSize CXISLDialogTag::DrawDialogFlow(CDC *pDC)
//@\@FDialog̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLDialogTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nCount = m_ExchangeList.GetCount();
	int nViewSizeX,nViewSizeY;
	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	//1.܂͎g`
	FlowBMP.LoadBitmap(m_nBmpID);
	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;
	pDC->MoveTo(nX,nY);

	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	nViewSizeX = nX;
	
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);
	//exchangeOȂ`
	if(nCount == 0 && m_pBegin == NULL)
	{
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
	}

	//2.begin`
	if(m_pBegin)
	{
		FlowBMP.LoadBitmap(m_pBegin->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		MemDC.SelectObject(&FlowBMP);

		pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		m_pBegin->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
		FlowBMP.DeleteObject();
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
		nY += bmp.bmHeight;

		pDC->MoveTo(nX,nY);
		nY += 10;
		pDC->LineTo(nX,nY);

		//exchangeOȂ`
		if(nCount == 0)
		{
			pDC->MoveTo(nX+4,nY-6);
			pDC->LineTo(nX,nY);
			pDC->MoveTo(nX-4,nY-6);
			pDC->LineTo(nX,nY);
		}
	}

	//3.exchange`
	if(nCount != 0)
	{
		int nBX = nX;
		int nBY = nY;
		int *npExcPoint = new int[nCount];
		nY += 20;
		for(int i=0;i<nCount;i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLExcItem *pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

			FlowBMP.LoadBitmap(pExcItem->m_nBmpID);
			FlowBMP.GetBitmap(&bmp);
			if(m_nComb != ID_XISLCOMB_SEQ && i == 0)
			{
				nX = nX - (bmp.bmWidth - 10);
				nY += 50;
			}
			MemDC.SelectObject(&FlowBMP);
			pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
			pExcItem->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
			npExcPoint[i] = nX;
			nViewSizeX = nX + bmp.bmWidth/2;

			pDC->MoveTo(nBX,nBY);
			if(m_nComb != ID_XISLCOMB_SEQ)
			{
				if(i == 0)
				{
					point[0].x = nBX;
					point[0].y = nBY+20;
					point[1].x = nX-10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				else
				{
					point[0].x = nBX;
					point[0].y = nBY+20;
					point[1].x = nX+10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				pDC->PolyBezierTo(point,3);
				//`
				pDC->MoveTo(nX+4,nY-6);
				pDC->LineTo(nX,nY);
				pDC->MoveTo(nX-4,nY-6);
				pDC->LineTo(nX,nY);
				nX = nX + bmp.bmWidth + 20;
			}
			else
			{
				pDC->LineTo(nX,nY);
				nBX = nX; nBY = nY + bmp.bmHeight;
				//`
				pDC->MoveTo(nX+4,nY-6);
				pDC->LineTo(nX,nY);
				pDC->MoveTo(nX-4,nY-6);
				pDC->LineTo(nX,nY);
				nY = nY + bmp.bmHeight + 20;
			}

			FlowBMP.DeleteObject();
		}

		if(m_nComb == ID_XISLCOMB_SEQ)
		{
			pDC->MoveTo(nBX,nBY);
			nY += 10;
			pDC->LineTo(nX,nY);
		}
		else
		{
			nX = nBX;
			nY += bmp.bmHeight;
			nBY = nY; 
			if(m_nComb == ID_XISLCOMB_PAR)
			{
				nY += 20;
				for(int i=0;i<nCount;i++)
				{
					pDC->MoveTo(npExcPoint[i],nBY);
					pDC->LineTo(npExcPoint[i],nY);
				}
				pDC->MoveTo(npExcPoint[0],nY);
				if(nCount == 1)
					pDC->LineTo(nBX,nY);
				else
					pDC->LineTo(npExcPoint[nCount-1],nY);
				pDC->MoveTo(nBX,nY);
				nY += 30;
				pDC->LineTo(nBX,nY);
			}
			else if(m_nComb == ID_XISLCOMB_ALT)
			{
				nY += 60;
				for(int i=0;i<nCount;i++)
				{
					pDC->MoveTo(npExcPoint[i],nBY);
					if(i == 0)
					{
						point[0].x = npExcPoint[i]+10;
						point[0].y = nBY+20;
						point[1].x = npExcPoint[i]-10;
						point[1].y = nBY+20;
						point[2].x = nX;
						point[2].y = nY;
					}
					else
					{
						point[0].x = npExcPoint[i];
						point[0].y = nBY+20;
						point[1].x = npExcPoint[i]+10;
						point[1].y = nBY+40;
						point[2].x = nX;
						point[2].y = nY;
					}
					pDC->PolyBezierTo(point,3);
				}
			}
		}
		if(m_pEnd == NULL)
		{
			nY += 10;
			pDC->LineTo(nX,nY);
			//`
			pDC->MoveTo(nX+4,nY-6);
			pDC->LineTo(nX,nY);
			pDC->MoveTo(nX-4,nY-6);
			pDC->LineTo(nX,nY);
		}
		delete [] npExcPoint;
	}

	if(m_pEnd)
	{
		nY += 10;
		pDC->LineTo(nX,nY);
		FlowBMP.LoadBitmap(m_pEnd->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);

		MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		m_pEnd->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
		FlowBMP.DeleteObject();
		//`
		pDC->MoveTo(nX+4,nY-6);
		pDC->LineTo(nX,nY);
		pDC->MoveTo(nX-4,nY-6);
		pDC->LineTo(nX,nY);
		nY += bmp.bmHeight;
	}

	nViewSizeY = nY;

	MemDC.SelectObject(pOldBMP);
//	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nViewSizeX+100,nViewSizeY+100);
}

//CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		if(m_pBegin)
		{
			pTag = m_pBegin->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
		for(int i=0;i<m_ExchangeList.GetCount();i++)
		{
			POSITION pos = m_ExchangeList.FindIndex(i);
			CXISLExcItem* pExcItem = (CXISLExcItem*)m_ExchangeList.GetAt(pos);

			pTag = pExcItem->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
		if(m_pEnd)
		{
			pTag = m_pEnd->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}

void CXISLDialogTag::SetDummy(int nDummyArgCount,LPCTSTR lpszDummyDocName)
{
	m_bDummy = TRUE;
	m_nDummyArgCount = nDummyArgCount;
	m_strDummyDocName = lpszDummyDocName;
}

//Exchange^O폜
//2003/5/19@
BOOL CXISLDialogTag::DeleteExchange(CXISLExchangeTag *pETag)
{
	POSITION pos = m_ExchangeList.Find(pETag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	//Exchange^OXg؂
	m_ExchangeList.RemoveAt(posdel);
	//Exchange^Õ^OS폜
	pETag->DeletePromptList();//vvg
	pETag->DeleteAllOpr();//Iy[V
	pETag->DeleteAllAct();//ANV
	//ް(LEEM)
	delete pETag;
	pETag=NULL;
	return TRUE;
}

BOOL CXISLDialogTag::DeleteCombExchange(CXISLCombExchangeTag *pCExcTag)
{
	POSITION pos = m_ExchangeList.Find(pCExcTag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	pCExcTag->DeleteCombExchangeList();
	//Exchange^OXg؂
	m_ExchangeList.RemoveAt(posdel);
	//Exchange^Õ^OS폜
	//ް(LEEM)
	delete pCExcTag;
	pCExcTag=NULL;
	return TRUE;
}

//Dialogȉ̑SẴ^O폜
void CXISLDialogTag::DeleteAll()
{
	if(m_pBegin!=NULL)
		DestroyBegin();
	if(m_ExchangeList.IsEmpty() == 0){
		CXISLExchangeTag *pETag = (CXISLExchangeTag *)m_ExchangeList.GetHead();
		DeleteExchange(pETag);
	}
	if(m_pEnd!=NULL)
		DestroyEnd();
}